/*
 * Decompiled with CFR 0.152.
 */
package com.zainjx.the_wild_update.mixin;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.math.Vector3f;
import com.zainjx.the_wild_update.math.CustomMath;
import com.zainjx.the_wild_update.registry.RegistryEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightTexture.class})
public class LightTextureMixin {
    @Shadow
    private boolean updateLightTexture;
    @Shadow
    private final Minecraft minecraft;
    @Shadow
    private float blockLightRedFlicker;
    @Shadow
    private final GameRenderer renderer;
    @Shadow
    private final NativeImage lightPixels;
    @Shadow
    private final DynamicTexture lightTexture;
    public double time;

    private float getBrightness(Level p_109889_, int p_109890_) {
        return p_109889_.m_6042_().m_63902_(p_109890_);
    }

    private float notGamma(float p_109893_) {
        float f = 1.0f - p_109893_;
        return 1.0f - f * f * f * f;
    }

    public LightTextureMixin(Minecraft minecraft, GameRenderer renderer, NativeImage lightPixels, DynamicTexture lightTexture) {
        this.minecraft = minecraft;
        this.renderer = renderer;
        this.lightPixels = lightPixels;
        this.lightTexture = lightTexture;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        if (this.minecraft.f_91074_.m_21023_((MobEffect)RegistryEffects.DARKNESS.get())) {
            this.time += 0.0375;
            CustomMath.time = this.time;
        } else {
            this.time = 0.0;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"updateLightTexture"})
    public void updateLightTexture(float p_109882_, CallbackInfo ci) {
        assert (this.minecraft.f_91074_ != null);
        double dark = this.minecraft.f_91074_.m_21023_((MobEffect)RegistryEffects.DARKNESS.get()) ? Math.cos(this.time) * 0.5 + 0.8 : 0.0;
        if (this.updateLightTexture) {
            this.updateLightTexture = false;
            this.minecraft.m_91307_().m_6180_("lightTex");
            ClientLevel clientlevel = this.minecraft.f_91073_;
            if (clientlevel != null) {
                float f = clientlevel.m_104805_(1.0f);
                float f1 = clientlevel.m_104819_() > 0 ? 1.0f : f * 0.95f + 0.05f;
                float f3 = this.minecraft.f_91074_.m_108639_();
                float f2 = this.minecraft.f_91074_.m_21023_(MobEffects.f_19611_) ? GameRenderer.m_109108_((LivingEntity)this.minecraft.f_91074_, (float)p_109882_) : (f3 > 0.0f && this.minecraft.f_91074_.m_21023_(MobEffects.f_19592_) ? f3 : 0.0f);
                Vector3f vector3f = new Vector3f(f, f, 1.0f);
                vector3f.m_122255_(new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
                float f4 = this.blockLightRedFlicker + 1.5f;
                Vector3f vector3f1 = new Vector3f();
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        float f10;
                        float f5 = this.getBrightness((Level)clientlevel, i) * f1;
                        float f6 = this.getBrightness((Level)clientlevel, j) * f4;
                        float f7 = f6 * ((f6 * 0.6f + 0.4f) * 0.6f + 0.4f);
                        float f8 = f6 * (f6 * f6 * 0.6f + 0.4f);
                        vector3f1.m_122245_(f6, f7, f8);
                        if (clientlevel.m_104583_().m_108884_()) {
                            vector3f1.m_122255_(new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                        } else {
                            Vector3f vector3f2 = vector3f.m_122281_();
                            vector3f2.m_122261_(f5);
                            vector3f1.m_122253_(vector3f2);
                            vector3f1.m_122255_(new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                            if (this.renderer.m_109131_(p_109882_) > 0.0f) {
                                float f9 = this.renderer.m_109131_(p_109882_);
                                Vector3f vector3f3 = vector3f1.m_122281_();
                                vector3f3.m_122263_(0.7f, 0.6f, 0.6f);
                                vector3f1.m_122255_(vector3f3, f9);
                            }
                        }
                        vector3f1.m_122242_(0.0f, 1.0f);
                        if (f2 > 0.0f && (f10 = Math.max(vector3f1.m_122239_(), Math.max(vector3f1.m_122260_(), vector3f1.m_122269_()))) < 1.0f) {
                            float f12 = 1.0f / f10;
                            Vector3f vector3f5 = vector3f1.m_122281_();
                            vector3f5.m_122261_(f12);
                            vector3f1.m_122255_(vector3f5, (float)dark * 3.0f + 1.2f);
                        }
                        float f11 = (float)this.minecraft.f_91066_.f_92071_;
                        Vector3f vector3f4 = vector3f1.m_122281_();
                        vector3f4.m_122258_(this::notGamma);
                        vector3f1.m_122255_(vector3f4, f11 - (float)dark * 2.0f);
                        vector3f1.m_122255_(new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                        vector3f1.m_122242_(0.0f, 1.0f);
                        vector3f1.m_122261_(255.0f);
                        int j1 = 255;
                        int k = (int)vector3f1.m_122239_();
                        int l = (int)vector3f1.m_122260_();
                        int i1 = (int)vector3f1.m_122269_();
                        this.lightPixels.m_84988_(j, i, 0xFF000000 | i1 << 16 | l << 8 | k);
                    }
                }
                this.lightTexture.m_117985_();
                this.minecraft.m_91307_().m_7238_();
            }
        }
    }
}

